
=begin

もんむす・くえすと！ＲＰＧ
　セーブ不具合対処 ver7  2015/07/11


用語
　通常セーブデータ　　　　　Save01.rvdata2など
　　　　　　　　　　　　　　　ゲーム内のセーブで保存
　バックアップセーブデータ　SaveBackup.rvdata2　　中身は通常セーブデータと同じ
　　　　　　　　　　　　　　　ゲーム内のセーブを一定回数すると保存
　オートセーブデータ　　　　AutoSave01.rvdata2　　中身は通常セーブデータと同じ
　　　　　　　　　　　　　　　特定のタイミングで保存

機能一覧　説明は下　このverで新規追加したものは●　変更したものは○
・通常セーブ失敗時、失敗原因のデータを表示
・通常セーブ失敗時、通常セーブデータが消失しないように
・通常セーブのバックアップ間隔を変更
○特定タイミングでのオートセーブ

機能説明
○特定タイミングでのオートセーブ
　①ランダムエンカウントの戦闘に勝利
　②メニューを開く
　のたび毎回オートセーブし、その成否をコンソールに表示する
　ただしセーブ禁止中ならオートセーブせず、その旨をコンソールに表示する

=end

module SaveData
  
  # セーブ失敗時にメッセージボックスで表示されるメッセージ
  # 先頭に【通常】【オート】【バックアップ】が入るので、冒頭は「セーブ」で
  # <1>の部分がバックアップセーブ失敗時のみ FailireMesBackUp に変換される
  # <2>の部分が「セーブ失敗原因: ○○」に変換される
  FailureMes1 = [
    "セーブに失敗しました",
    "ただちにゲームを閉じて、ＰＣを再起動してください<1>",
    "",
    "<2>",
    "",
    "この上の「セーブ失敗原因」が「不明」の場合は",
    "ＰＣの環境が原因であり、再起動すればしばらく発生しなくなると思われます",
    "",
    "「不明」以外の場合は、以下の3点を報告してください",
    "①「セーブ失敗原因: ○○」の内容",
    "②前回の『「メニュー開く」か「エンカウント戦闘勝利」』から現時点までに行った行為",
    "③現在のだいたいのストーリー進行状況",
  ]
  
  # サムネイルの保存失敗時にメッセージボックスに表示されるメッセージ
  # 先頭に【通常】【オート】【バックアップ】が入るので、冒頭は「セーブ」で
  # <1>の部分がバックアップセーブ失敗時のみ FailireMesBackUp に変換される
  FailureMes2 = [
    "セーブ時のサムネイル画像の作成に失敗しました",
    "ただちにゲームを閉じて、ＰＣを再起動してください<1>",
    "",
    "セーブ画面/ロード画面で表示するサムネイル画像が更新されていないだけで",
    "セーブ自体は正常に行われました",
    "",
    "ＰＣの環境が原因であり、再起動すればしばらく発生しなくなると思われます",
  ]
  
  # バックアップの失敗時に追加されるメッセージ
  FailureMesBackUp = "（バックアップに失敗しただけなので、本来のセーブデータには問題ありません）"
  
  # バックアップセーブデータの保存間隔を変更　以前は5
  # 通常セーブ時に「セーブ回数 ÷ この値」の余りが0ならばバックアップを作成する
  BackUpNum = 1
  
  # オートセーブ読込コマンドの名前
  AutoCommandName = "Load Autosave"
  
  # タイトル画面のコマンドウインドウ横幅　デフォルト:160
  TitleCommandWidth = 214
  
end

#==============================================================================
# ■ Game_System
#==============================================================================
class Game_System
  #--------------------------------------------------------------------------
  # ● セーブ前の処理
  #--------------------------------------------------------------------------
  def on_before_auto_save
    @save_count -= 1
  end
end

#==============================================================================
# ■ Window_TitleCommand
#==============================================================================
class Window_TitleCommand < Window_Command
  #--------------------------------------------------------------------------
  # ● オートセーブ読み込みの有効状態を取得
  #--------------------------------------------------------------------------
  def auto_continue_enabled
    DataManager.auto_save_file_exists?
  end
  #--------------------------------------------------------------------------
  # ● ウィンドウ幅の取得
  #--------------------------------------------------------------------------
  def window_width
    return SaveData::TitleCommandWidth
  end
end

#==============================================================================
# ■ Scene_AutoSave_Load
#==============================================================================
class Scene_AutoSave_Load < Scene_Load
  #--------------------------------------------------------------------------
  # ● ヘルプウィンドウのテキストを取得
  #--------------------------------------------------------------------------
  def help_window_text
    "Choose an autosave to load"
  end
  #--------------------------------------------------------------------------
  # ● 最初に選択状態にするファイルインデックスを取得
  #--------------------------------------------------------------------------
  def first_savefile_index
    0
  end
  #--------------------------------------------------------------------------
  # ● 項目数の取得
  #--------------------------------------------------------------------------
  def item_max
    3
  end
  #--------------------------------------------------------------------------
  # ● セーブファイルの決定
  #--------------------------------------------------------------------------
  def on_savefile_ok
    if DataManager.load_game("01")
      on_load_success
    else
      Sound.play_buzzer
    end
  end
  #--------------------------------------------------------------------------
  # ● セーブファイルウィンドウの作成
  #--------------------------------------------------------------------------
  def create_savefile_windows
    @savefile_windows = Array.new(item_max) do |i|
      Window_AutoSaveFile.new(savefile_height, i)
    end
    @savefile_windows.each {|window| window.viewport = @savefile_viewport }
  end
  #--------------------------------------------------------------------------
  # ● カーソルの更新
  #--------------------------------------------------------------------------
  def update_cursor
  end
end
#==============================================================================
# ■ Window_AutoSaveFile
#==============================================================================
class Window_AutoSaveFile < Window_SaveFile
  #--------------------------------------------------------------------------
  # ● オブジェクト初期化
  #--------------------------------------------------------------------------
  def initialize(height, index_num)
    @file_index_num = index_num
    super(height, index_num)
    @file_index = sprintf("%02d", index_num + 1)
    refresh
    contents.clear if index_num != 0
    @selected = false
  end
  #--------------------------------------------------------------------------
  # ● ファイル名の描画
  #--------------------------------------------------------------------------
  def draw_filename(x, y)
    change_color(normal_color)
    name = Vocab::File + " #{@file_index_num + 1}"
    draw_text(x, y, 200, line_height, name)
    @name_width = text_size(name).width
  end
  #--------------------------------------------------------------------------
  # ● サムネイルの描画
  #--------------------------------------------------------------------------
  def draw_thumbnail(x, y)
    thumbnail = DataManager.get_thumbnail(@file_index)
    thumbnail ||= DataManager.get_dummy_thumbnail
    contents.blt(x, y, thumbnail, thumbnail.rect)
    draw_text(x + 4, y, 200, line_height, "Autosave")
    return unless DataManager.load_header(@file_index)
    save_index = DataManager.load_header(@file_index)[:save_index]
    return unless save_index.is_a?(Integer)
    t = "File #{save_index + 1}"
    draw_text(x + 4, y + line_height, 200, line_height, t) 
  end
end
